package JavaPonies;
/*
 * This is a custom JFormattedTextField to handle number inputs with two buttons to increment and decrement
 */
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;

import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;

@SuppressWarnings("serial")
public class JNumField extends JFormattedTextField implements ActionListener {
	public JNumField() {
		super(NumberFormat.getInstance());

		initializeNumField();
	}

	// Overridden getText() function to make sure we never return a non-numeric text
	public String getText() {
		String text = super.getText();
		
		try {
			Integer.parseInt(text);
			return text;
		} catch(Exception ex) {
			return "0";
		}	
	}
	
	// Constructor
	public JNumField(String text) {
		super(NumberFormat.getInstance());
		this.setText(text);
		
		// Initialize the control
		initializeNumField();
	}
	
	// Initialize the increment buttons and handlers
	private void initializeNumField() {
		this.setLayout(new BorderLayout());
		
		// Initialize increment and decrement buttons
		JButton pressup = new JButton();
		pressup.setActionCommand("up");
		pressup.addActionListener(this);
		JButton pressdown = new JButton();
		pressdown.setActionCommand("down");
		pressdown.addActionListener(this);
		
		// Add the buttons to the control
		GridLayout buttongrid = new GridLayout(2,1);
		buttongrid.setHgap(0);
		buttongrid.setVgap(0);
		JPanel buttons = new JPanel(buttongrid);
		buttons.setPreferredSize(new Dimension(20,20));
		
		buttons.add(pressup);
		buttons.add(pressdown);
		
		this.add(buttons, BorderLayout.EAST);
	}

	// actionPerformed handler
	public void actionPerformed(ActionEvent e) {
		// If up, increment by one, if down, decrement, kiddy stuff
		if (e.getActionCommand() == "up") {
			int i = Integer.parseInt(this.getText());
			i++;
			this.setText(Integer.toString(i));
		} else if (e.getActionCommand() == "down") {
			int i = Integer.parseInt(this.getText());
			i = Math.max(0, i - 1);
			this.setText(Integer.toString(i));
		}
	}
}
